<?php $__env->startSection('title',  $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet { margin-bottom: 0px; }
        body.dark .toggle-code-snippet { margin-bottom: 0px; }
    </style>
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->


<!-- BEGIN BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
<div class="page-meta">
    <nav class="breadcrumb-style-one" aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('courses.index')); ?>">Courses</a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
        </ol>
    </nav>
</div>
<?php $__env->stopSection(); ?>
<!-- END BREADCRUMB -->
<?php $__env->startSection('content'); ?>
<h5>
Name: <?php echo e($course->name); ?><br/>
Term: <?php if($course->term === 'Y'): ?> Full Year <?php elseif($course->term === 'F'): ?> Fall <?php else: ?> Spring <?php endif; ?><br/>
Dept: <?php echo e($course->department->name); ?><br/>
Minimum Grade: <?php echo e($course->minimum_grade); ?><br/>
Delivery: <?php if($course->delivery === 'I'): ?> ITV <?php else: ?> Online <?php endif; ?><br/>
Dual Credit: <?php if($course->dual_credit === 'Y'): ?> Yes <?php else: ?> No <?php endif; ?>
</h5>
</div>

<!-- List Sections -->
<?php if($course->sections->isEmpty()): ?>
<h4>No Sections Found</h4>
<?php else: ?>
<div class="accordion" id="sectionAccordion">
    <?php $__currentLoopData = $course->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <h4><?php echo e($course->sections->count()); ?> Sections</h4>
        <div class="accordion-item mb-4">
            <h2 class="accordion-header">
            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($s->id); ?>" aria-expanded="false" aria-controls="collapse<?php echo e($s->id); ?>">
                <?php echo e($s->year->year); ?> (<?php echo e($course->enrollments->count()); ?> Enrollments)
            </button>
            </h2>
            <div id="collapse<?php echo e($s->id); ?>" class="accordion-collapse collapse" data-bs-parent="#sectionAccordion">
                <div class="accordion-body">
                    <!-- List Enrollments -->
                    <?php if($course->enrollments->isEmpty()): ?>
                        <h4>No Enrollments Found</h4>
                    <?php else: ?>
                        <h5><?php echo e($course->enrollments->count()); ?> Enrollments</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover mb-4">
                                <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>School</th>
                                    <th>Status</th>
                                    <th>LMS Updated?</th>
                                    <th>Dual Credit</th>
                                    <th>Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $course->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($e->student->last_name . ', ' . $e->student->first_name); ?></td>
                                        <td><?php echo e($e->student->school->name); ?></td>
                                        <td><?php if($e->status === 'A'): ?> Approved  <?php elseif($e->status === 'D'): ?> Denied <?php elseif($e->status === 'R'): ?> Dropped <?php else: ?> Waitlist <?php endif; ?> </td>
                                        <td><?php if($e->lms): ?> Yes <?php else: ?> No <?php endif; ?> </td>
                                        <td><?php if($e->dual_credit): ?> Yes <?php else: ?> No <?php endif; ?> </td>
                                        <td><a href="<?php echo e(route('enrollments.show', $e->id)); ?>">View</a> |
                                            <a href="<?php echo e(route('enrollments.edit', $e->id)); ?>">Edit</a> |
                                            <a href="<?php echo e(route('enrollments.delete', $e->id)); ?>">Delete</a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>
<p class="mt-2">
<button class="btn btn-warning mb-2" onclick="window.location.href = '<?php echo e(route("courses.edit", $course->id)); ?>';">Edit Course</button> <button class="btn btn-danger mb-2" onclick="window.location.href = '<?php echo e(route("courses.delete", $course->id)); ?>';">Delete Course</button>
</p>
<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>

<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\jason_horner\Dropbox\laravel\10\registration\resources\views/admin/courses/show.blade.php ENDPATH**/ ?>