<?php $__env->startSection('title', $title); ?>

<!-- BEGIN PAGE CSS -->
<?php $__env->startSection('page-css'); ?>
    <style>
        .toggle-code-snippet {
            margin-bottom: 0px;
        }

        body.dark .toggle-code-snippet {
            margin-bottom: 0px;
        }
    </style>
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/src/table/datatable/datatables.css">

    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/light/table/datatable/custom_dt_miscellaneous.css">

    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/dt-global_style.css">
    <link rel="stylesheet" type="text/css" href="/cork/src/plugins/css/dark/table/datatable/custom_dt_miscellaneous.css">
<?php $__env->stopSection(); ?>
<!-- END PAGE CSS -->

<!-- BREADCRUMB -->
<?php $__env->startSection('breadcrumb'); ?>
    <div class="page-meta">
        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('enrollments.index')); ?>">Enrollments</a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($title); ?></li>
            </ol>
        </nav>
    </div>
    <!-- /BREADCRUMB -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('enrollments.upload-powerschool-students')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <table id="enrollments" class="table dt-table-hover" style="width:100%">
            <thead>
                <tr>
                    <th><input type="checkbox" id="select-all"></th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Middle_name</th>
                    <th>Gender</th>
                    <th>Grade_level</th>
                    <th>Last_name</th>
                    <th>First_name</th>
                    <th>DOB</th>
                    <th>State_studentnumber</th>
                    <th>student_number</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $e = App\Models\Enrollment::find($e->id) ?>
                    <?php if($e->student->ssid == 0): ?>
                        <?php continue; ?>
                    <?php endif; ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="enrollment_ids[]" value="<?php echo e($e->id); ?>">
                        </td>
                        <td>
                            <?php echo e(date('m/d/Y H:i:s', strtotime($e->updated_at > $e->created_at ? $e->updated_at : $e->created_at))); ?>

                        </td>
                        <td>
                            <?php if($e->status == 'R' || $e->status == 'D'): ?>
                                <span style="background-color: #FA8072"><?php echo e($e->statusDesc()); ?></span>
                            <?php elseif($e->status == 'W'): ?>
                                <span style="background-color: #C4B454"><?php echo e($e->statusDesc()); ?></span>
                            <?php else: ?>
                                <?php echo e($e->statusDesc()); ?>

                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($e->student->school->name); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->gender); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->grade); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->last_name); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->first_name); ?>

                        </td>
                        <td>
                            <?php echo e(date('m/d/Y', strtotime($e->student->dob))); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->ssid); ?>

                        </td>
                        <td>
                            <?php echo e($e->student->ssid); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <div class="form-row">
            <button type="submit" class="mt-4 btn btn-primary">Mark as Done</button>
            <button type="button" class="mt-4 ml-4 btn btn-secondary"
                onclick="window.history.go(-1); return false;">Cancel</button>
        </div>
    </form>

<?php $__env->stopSection(); ?>
<!--  BEGIN PAGE SCRIPTS FILE  -->
<?php $__env->startSection('page-js'); ?>
    <script src="/cork/src/plugins/src/table/datatable/datatables.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/dataTables.buttons.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/jszip.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.html5.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/button-ext/buttons.print.min.js"></script>
    <script src="/cork/src/plugins/src/table/datatable/custom_miscellaneous.js"></script>

    <script>
        $('#enrollments').DataTable({
            "dom": "<'dt--top-section'<'row'<'col-sm-12 col-md-6 d-flex justify-content-md-start justify-content-center'B><'col-sm-12 col-md-6 d-flex justify-content-md-end justify-content-center mt-md-0 mt-3'f>>>" +
                "<'table-responsive'tr>" +
                "<'dt--bottom-section d-sm-flex justify-content-sm-between text-center'<'dt--pages-count  mb-sm-0 mb-3'i><'dt--pagination'p>>",
            buttons: [{
                extend: 'csv',
                className: 'btn',
                exportOptions: {
                    columns: [3, 4, 5, 6, 7, 8, 9, 10]
                }
            }],
            "oLanguage": {
                "oPaginate": {
                    "sPrevious": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left"><line x1="19" y1="12" x2="5" y2="12"></line><polyline points="12 19 5 12 12 5"></polyline></svg>',
                    "sNext": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>'
                },
                "sInfo": "Showing page _PAGE_ of _PAGES_",
                "sSearch": '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search"><circle cx="11" cy="11" r="8"></circle><line x1="21" y1="21" x2="16.65" y2="16.65"></line></svg>',
                "sSearchPlaceholder": "Search...",
                "sLengthMenu": "Results :  _MENU_",
            },
            "stripeClasses": [],
            "lengthMenu": [25, 50, 75, 100, -1],
            "pageLength": -1
        });
    </script>
    <script>
        $(document).ready(function() {
            // Select/Deselect all checkboxes
            $('#select-all').click(function() {
                $('input[name="enrollment_ids[]"]').prop('checked', this.checked);
            });

            // If any checkbox is unchecked, uncheck the 'select all' checkbox
            $('input[name="enrollment_ids[]"]').change(function() {
                if (!this.checked) {
                    $('#select-all').prop('checked', false);
                }

                // If all checkboxes are checked, check the 'select all' checkbox
                if ($('input[name="enrollment_ids[]"]').length === $(
                        'input[name="enrollment_ids[]"]:checked').length) {
                    $('#select-all').prop('checked', true);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<!--  END PAGE SCRIPTS FILE  -->

<?php echo $__env->make('layouts.cork', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/psjybwmy/public_html/registration/resources/views/admin/enrollments/upload-powerschool-students.blade.php ENDPATH**/ ?>